/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.jaxws;

import java.net.URL;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.GatewayServiceLocator;
import org.josso.gateway.identity.service.SSOIdentityManagerService;
import org.josso.gateway.identity.service.SSOIdentityProviderService;
import org.josso.gateway.jaxws.identity.service.WebserviceSSOIdentityManager;
import org.josso.gateway.jaxws.identity.service.WebserviceSSOIdentityProvider;
import org.josso.gateway.jaxws.session.service.WebserviceSSOSessionManager;
import org.josso.gateway.session.service.SSOSessionManagerService;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityManager;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityManagerWS;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityProvider;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityProviderWS;
import org.josso.gateway.ws._1_2.wsdl.SSOSessionManager;
import org.josso.gateway.ws._1_2.wsdl.SSOSessionManagerWS;

public class JAXWSWebserviceGatewayServiceLocator
extends GatewayServiceLocator {
    private static final Log logger = LogFactory.getLog(JAXWSWebserviceGatewayServiceLocator.class);
    private String wsdlLocation;

    public SSOSessionManagerService getSSOSessionManager() throws Exception {
        SSOSessionManager port = new SSOSessionManagerWS(this.wsdlLocation == null ? SSOSessionManagerWS.WSDL_LOCATION : new URL(this.wsdlLocation)).getSSOSessionManagerSoap();
        String smEndpoint = this.getSSOSessionManagerEndpoint();
        logger.debug((Object)("Using SSOSessionManager endpoint '" + smEndpoint + "'"));
        this.setEndpointAddress(port, smEndpoint);
        WebserviceSSOSessionManager wsm = new WebserviceSSOSessionManager(port);
        return wsm;
    }

    public SSOIdentityManagerService getSSOIdentityManager() throws Exception {
        SSOIdentityManager port = new SSOIdentityManagerWS(this.wsdlLocation == null ? SSOIdentityManagerWS.WSDL_LOCATION : new URL(this.wsdlLocation)).getSSOIdentityManagerSoap();
        String imEndpoint = this.getSSOIdentityManagerEndpoint();
        logger.debug((Object)("Using SSOIdentityManager endpoint '" + imEndpoint + "'"));
        this.setEndpointAddress(port, imEndpoint);
        WebserviceSSOIdentityManager wim = new WebserviceSSOIdentityManager(port);
        return wim;
    }

    public SSOIdentityProviderService getSSOIdentityProvider() throws Exception {
        SSOIdentityProvider port = new SSOIdentityProviderWS(this.wsdlLocation == null ? SSOIdentityProviderWS.WSDL_LOCATION : new URL(this.wsdlLocation)).getSSOIdentityProviderSoap();
        String ipEndpoint = this.getSSOIdentityProviderEndpoint();
        logger.debug((Object)("Using SSOIdentityProvider endpoint '" + ipEndpoint + "'"));
        this.setEndpointAddress(port, ipEndpoint);
        WebserviceSSOIdentityProvider wip = new WebserviceSSOIdentityProvider(port);
        return wip;
    }

    private void setEndpointAddress(Object port, String newAddress) {
        assert (port instanceof BindingProvider) : "Doesn't appear to be a valid port";
        assert (newAddress != null) : "Doesn't appear to be a valid address";
        BindingProvider bp = (BindingProvider)port;
        Map context = bp.getRequestContext();
        Object oldAddress = context.get("javax.xml.ws.service.endpoint.address");
        context.put("javax.xml.ws.service.endpoint.address", newAddress);
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }
}

