/*
 * Decompiled with CFR 0.152.
 */
package org.josso.jaspi.agent;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.security.auth.message.module.ServerAuthModule;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.josso.jaspi.agent.JASPICallbackHandler;

public abstract class JOSSOServerAuthModule
implements ServerAuthModule {
    protected CallbackHandler callbackHandler;
    protected Map options;

    public Class[] getSupportedMessageTypes() {
        return new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.callbackHandler = handler;
        this.options = options;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        Principal principal = request.getUserPrincipal();
        if (subject != null && principal != null) {
            subject.getPrincipals().remove(principal);
        }
    }

    public abstract AuthStatus secureResponse(MessageInfo var1, Subject var2) throws AuthException;

    public abstract AuthStatus validateRequest(MessageInfo var1, Subject var2, Subject var3) throws AuthException;

    protected void registerWithCallbackHandler(Principal userPrincipal, String username, String password, String[] groups) {
        if (!(this.callbackHandler instanceof JASPICallbackHandler)) {
            throw new RuntimeException("Unsupported Callback handler " + this.callbackHandler.getClass().getCanonicalName());
        }
        JASPICallbackHandler cbh = (JASPICallbackHandler)this.callbackHandler;
        char[] pass = password == null ? "".toCharArray() : password.toCharArray();
        PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(null, username, pass);
        cbh.setPasswordValidationCallback(passwordValidationCallback);
        cbh.setCallerPrincipalCallback(new CallerPrincipalCallback(null, userPrincipal));
        cbh.setGroupPrincipalCallback(new GroupPrincipalCallback(null, groups));
    }
}

