/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.SecurityDomain;
import org.josso.gateway.SecurityDomainRegistry;

public class SecurityDomainRegistryImpl
implements SecurityDomainRegistry {
    private static final Log logger = LogFactory.getLog(SecurityDomainRegistryImpl.class);
    private Map<String, SecurityDomainRecord> domainRecords = new HashMap<String, SecurityDomainRecord>();

    public SecurityDomain lookup(String tokenType, String token) {
        for (SecurityDomainRecord r : this.domainRecords.values()) {
            if (!r.hasToken(tokenType, token)) continue;
            return r.getSecurityDomain();
        }
        return null;
    }

    public synchronized void register(SecurityDomain sd) {
        logger.info((Object)("Registering SecurityDomain : " + sd.getName()));
        this.domainRecords.put(sd.getName(), new SecurityDomainRecord(sd));
    }

    public synchronized void unregister(String securityDomainName) {
        logger.info((Object)("Unregistering SecurityDomain : " + securityDomainName));
        this.domainRecords.remove(securityDomainName);
    }

    public synchronized void registerToken(String securityDomainName, String tokenType, String token) {
        if (securityDomainName == null) {
            throw new IllegalArgumentException("Security Domain Name cannot be null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering security token " + securityDomainName + " [" + tokenType + "/" + token + "]"));
        }
        SecurityDomainRecord r = this.domainRecords.get(securityDomainName);
        r.addToken(tokenType, token);
    }

    public synchronized void unregisterToken(String securityDomainName, String tokenType, String token) {
        SecurityDomainRecord r;
        if (securityDomainName == null) {
            throw new IllegalArgumentException("Security Domain Name cannot be null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unregistering security token " + securityDomainName + " [" + tokenType + "/" + token + "]"));
        }
        if ((r = this.domainRecords.get(securityDomainName)) != null) {
            r.removeToken(tokenType, token);
        }
    }

    protected class SecurityDomainRecord {
        private SecurityDomain sd;
        private Map<String, Set<String>> tokens = new HashMap<String, Set<String>>();

        public SecurityDomainRecord(SecurityDomain sd) {
            this.sd = sd;
        }

        public SecurityDomain getSecurityDomain() {
            return this.sd;
        }

        public boolean hasToken(String type, String token) {
            Set<String> tokenValues = this.tokens.get(type);
            return tokenValues != null && tokenValues.contains(token);
        }

        public void addToken(String type, String token) {
            Set<String> tokenValues = this.tokens.get(type);
            if (tokenValues == null) {
                tokenValues = new HashSet<String>();
                this.tokens.put(type, tokenValues);
            }
            tokenValues.add(token);
        }

        public void removeToken(String type, String token) {
            Set<String> tokenValues = this.tokens.get(type);
            if (tokenValues == null) {
                return;
            }
            tokenValues.remove(token);
        }
    }
}

